<?php

namespace IPS\heleket\modules\front\system;

/* To prevent PHP errors (extending class does not exist) revealing path */
use IPS\Dispatcher\Controller;
use IPS\nexus\Fraud\MaxMind\Request;
use IPS\nexus\Transaction;
use IPS\Output;
use IPS\Settings;
use function defined;

if (!defined('\IPS\SUITE_UNIQUE_KEY'))
{
	header(($_SERVER['SERVER_PROTOCOL'] ?? 'HTTP/1.0') . ' 403 Forbidden');
	exit;
}

/**
 * callback
 */
class _callback extends Controller
{
	/**
	 * Execute
	 *
	 * @return    void
	 */
	public function execute()
	{

		parent::execute();
	}

	/**
	 * ...
	 *
	 * @return    void
	 */
	protected function manage()
	{
		if (\IPS\Request::i()->notify)
		{
			$jsonString = file_get_contents('php://input');
			$jsonArray = json_decode($jsonString, true) ?? [];

			if(!empty($jsonArray['order_id']))
			{
				$transaction = Transaction::load($jsonArray['order_id']);
				$settings = json_decode($transaction->method->settings, true);

				$status = $jsonArray['status'];

				$signature = $jsonArray['sign'];
				$signatureArray = $jsonArray;
				unset($signatureArray['sign']);
				$generatedSignature = $this->getSignature(
					json_encode($signatureArray, JSON_UNESCAPED_UNICODE),
					$settings['api_key']
				);
				if (hash_equals($signature, $generatedSignature))
				{
					if (in_array($jsonArray['status'], ['paid', 'paid_over']))
					{
						$transaction->gw_id = $jsonArray['order_id'];
						$transaction->save();

						$maxMind = null;
						if (Settings::i()->maxmind_key)
						{
							$maxMind = new Request;
							$maxMind->setTransaction($transaction);
						}

						$transaction->checkFraudRulesAndCapture($maxMind);
					}
				}

				\IPS\Output::i()->sendOutput('OK', 200);
			}
		}
		else
		{
			Output::i()->sendOutput('Something went wrong');
		}

		\IPS\Output::i()->sendOutput('No action', 200);
	}

	public function getSignature(string $data, string $apiKey): string
	{
		return hash('md5', base64_encode($data) . $apiKey);
	}
}
