<?php

if (!defined('ABSPATH'))
{
	exit();
}

$params = get_query_var('params');
get_header();

wp_enqueue_style(
	'heleket-form-custom-2',
	plugin_dir_url(dirname(__FILE__)) . 'css/form_custom_1.css',
	null,
	'1.5.3'
);

wp_enqueue_script(
	'heleket-form-2-js',
	plugin_dir_url(dirname(__FILE__)) . 'js/h2h-payment.js',
	['jquery'],
	'1.5.3',
	true
);

?>

<div class="heleket-flex-column">
	<input type="hidden" id="orderIdInput" value="<?php echo esc_attr($params['payment']['order_id']) ?>" />
	<div class="heleket-payment-form">
		<h3>CUSTOM TEMPLATE (REMOVE THIS LINE)</h3>
		<div class="heleket-form-information">
			<p><?php echo esc_html__('Amount', 'heleket-crypto-gateway-for-woocommerce') ?></p>
			<h1>
				<span><?php echo esc_html($params['payment']['payer_amount']) ?> <?php echo esc_html($params['payment']['payer_currency']) ?></span>
			</h1>
		</div>
		<div class="heleket-form-element">
			<div style="display: inline-block; margin-right: 180px;">
				<div class="coin">
					<p><?php echo esc_html__('Coin', 'heleket-crypto-gateway-for-woocommerce') ?></p>
					<p>
						<span><?php echo esc_html($params['payment']['payer_currency']) ?></span>
					</p>
				</div>
				<div class="Status">
					<p><?php echo esc_html__('Status', 'heleket-crypto-gateway-for-woocommerce') ?></p>
					<p>
						<span id="statusDisplay"><?php echo esc_html($params['payment']['status']) ?></span>
					</p>
				</div>
			</div>

			<div style="display: inline-block; margin-right: 180px;">
				<div class="Network">
					<p><?php echo esc_html__('Network', 'heleket-crypto-gateway-for-woocommerce') ?></p>
					<p>
						<span><?php echo esc_html($params['payment']['network']) ?></span>
					</p>
				</div>

				<div class="Time">
					<p><?php echo esc_html__('Time', 'heleket-crypto-gateway-for-woocommerce') ?></p>
					<p>
						<input type="hidden" id="timerDisplayUnix" value="<?php echo esc_attr($params['payment']['expired_at']) ?>" />
						<span id="timerDisplay"></span>
					</p>
				</div>
			</div>
		</div>

		<div class="heleket-form-address">
			<div>
				<p><?php echo esc_html__('Address', 'heleket-crypto-gateway-for-woocommerce') ?></p>
				<p>
					<span><?php echo esc_html($params['payment']['address']) ?></span>
				</p>

			</div>
		</div>
		<div class="heleket-form-qr">
			<span><img src="<?php echo esc_attr($params['payment']['address_qr_code']) ?>" /></span>
		</div>
		<div class="heleket-form-button">
			<input type="hidden" id="successUrl" value="<?php echo esc_attr($params['success_url']) ?>" />
			<input type="hidden" id="returnUrl" value="<?php echo esc_attr($params['return_url']) ?>" />

			<button type="submit" id="checkStatusButton"><?php echo esc_html__('Check', 'heleket-crypto-gateway-for-woocommerce') ?></button>
			<button type="submit" id="returnToOrder"><?php echo esc_html__('Return', 'heleket-crypto-gateway-for-woocommerce') ?></button>
		</div>
	</div>
</div>

<?php get_footer() ?>
