<?php

if (!defined('ABSPATH'))
{
	exit();
}

$params = get_query_var('params');
get_header();

wp_enqueue_style(
	'heleket-form-custom-1',
	plugin_dir_url(dirname(__FILE__)) . 'css/form_custom_1.css',
	null,
	'1.5.3'
);

wp_enqueue_script(
	'heleket-form-1-js',
	plugin_dir_url(dirname(__FILE__)) . 'js/currency.js',
	['jquery'],
	'1.5.3',
	true
);

?>

<div class="heleket-flex-column">
	<div class="heleket-payment-form">
		<h3>CUSTOM TEMPLATE (REMOVE THIS LINE)</h3>
		<div class="heleket-form-element">
			<p><?php echo esc_html__('Amount', 'heleket-crypto-gateway-for-woocommerce') ?></p>
			<h1>
				<span><?php echo esc_html($params['order_amount']) ?> <?php echo esc_html($params['order_currency']) ?></span>
			</h1>
		</div>
		<form action="/heleket-pay/" method="get">
			<input name="order_id" value="<?php echo esc_html($params['order_id']) ?>" type="hidden" />
			<input name="step_id" value="2" type="hidden" />

			<div class="heleket-form-element">
				<label for="to_currency"><?php echo esc_html__('Coin', 'heleket-crypto-gateway-for-woocommerce') ?></label>
				<select id="to_currency" name="to_currency">
					<?php foreach ($params['unique_coins'] as $currency): ?>
						<option value="<?php echo esc_attr($currency) ?>"><?php echo esc_attr($currency) ?></option>
					<?php endforeach ?>
				</select>
			</div>
			<div class="heleket-form-element">
				<label for="network"><?php echo esc_html__('Network', 'heleket-crypto-gateway-for-woocommerce') ?></label>
				<select id="network" name="network">
					<?php foreach ($params['currencies'] as $currency): ?>
						<option value="<?php echo esc_attr($currency['network']) ?>"
								data-coin="<?php echo esc_attr($currency['currency']) ?>"><?php echo esc_attr($currency['network']) ?></option>
					<?php endforeach; ?>
				</select>
			</div>
			<div class="heleket-form-element">
				<button type="submit"><?php echo esc_html__('Pay', 'heleket-crypto-gateway-for-woocommerce') ?></button>
			</div>
		</form>
	</div>
</div>

<?php get_footer() ?>
