document.addEventListener('DOMContentLoaded', function ()
{
	var orderId = document.getElementById('orderIdInput').value;
	var expiredAtUnix = document.getElementById('timerDisplayUnix').value;

	var timerDisplay = document.getElementById('timerDisplay');
	var statusDisplay = document.getElementById('statusDisplay');

	function formatTime(seconds)
	{
		var hours = Math.floor(seconds / 3600);
		var minutes = Math.floor((seconds % 3600) / 60);
		var remainingSeconds = seconds % 60;

		return hours.toString().padStart(2, '0') + ':' +
			minutes.toString().padStart(2, '0') + ':' +
			remainingSeconds.toString().padStart(2, '0');
	}

	function updateTimer()
	{
		var currentTimeUnix = Math.floor(Date.now() / 1000);
		var remainingTime = expiredAtUnix - currentTimeUnix;
		if (remainingTime <= 0)
		{
			clearInterval(timerInterval);
			timerDisplay.textContent = 'Expired';
		}
		else
		{
			timerDisplay.textContent = formatTime(remainingTime);
		}
	}

	var timerInterval = setInterval(updateTimer, 1000);
	updateTimer();

	function checkOrderStatus()
	{
		fetch('/wp-json/heleket-pay/check-status', {
			method: 'POST',
			headers: {
				'Content-Type': 'application/json'
			},
			body: JSON.stringify({order_id: orderId})
		})
			.then(response => response.json())
			.then(data =>
			{
				if (data.status)
				{
					statusDisplay.textContent = data.payment_status;
					if (['paid', 'paid_over'].indexOf(data.payment_status) >= 0)
					{
						window.location.href = document.getElementById('successUrl').value;
					}
				}
				else
				{
					statusDisplay.textContent = 'Error: ' + data.error;
				}
			})
			.catch(error => console.error('Error:', error));
	}

	checkOrderStatus();

	var intervalId = setInterval(checkOrderStatus, 60 * 1000);

	document.getElementById('checkStatusButton').addEventListener('click', function ()
	{
		checkOrderStatus();
	});

	document.getElementById('returnToOrder').addEventListener('click', function ()
	{
		window.location.href = document.getElementById('returnUrl').value;
	});

	window.addEventListener('beforeunload', function ()
	{
		clearInterval(intervalId);
	});
});