document.addEventListener('DOMContentLoaded', function ()
{
	var networkSelect = document.getElementById('network');
	var currencySelect = document.getElementById('to_currency');

	function updateNetworks()
	{
		var selectedCoin = currencySelect.value;
		var options = networkSelect.options;
		for (var i = 0; i < options.length; i++)
		{
			var option = options[i];
			var coin = option.getAttribute('data-coin');
			option.style.display = coin === selectedCoin ? 'block' : 'none';
		}
		for (var i = 0; i < options.length; i++)
		{
			if (options[i].style.display !== 'none')
			{
				networkSelect.selectedIndex = i;
				break;
			}
		}
	}

	currencySelect.addEventListener('change', updateNetworks);
	updateNetworks();
});