<?php

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

final class Heleket_Gateway_Blocks extends AbstractPaymentMethodType
{
	private $gateway;
	protected $name = 'heleket-crypto-gateway-for-woocommerce';

	public function initialize()
	{
		$this->settings = get_option("woocommerce_{$this->name}_settings", []);
		$gateways = WC()->payment_gateways->payment_gateways();
		$this->gateway = $gateways[$this->name];
	}

	public function is_active()
	{
		return
			!empty($this->settings['enabled'])
			&& $this->settings['enabled'] === 'yes';
	}

	public function get_payment_method_script_handles()
	{
		wp_register_script(
			'heleket-crypto-gateway-for-woocommerce-gateway-blocks-integration',
			plugin_dir_url(__FILE__) . 'js/checkout.js',
			[
				'wc-blocks-registry',
				'wc-settings',
				'wp-element',
				'wp-html-entities',
				'wp-i18n',
			],
			'1.5.3',
			true
		);

		return ['heleket-crypto-gateway-for-woocommerce-gateway-blocks-integration'];
	}

	public function get_payment_method_data()
	{
		return [
			'title'       => $this->get_setting('method_title'),
			'description' => $this->get_setting('description'),
			'supports'    => array_filter($this->gateway->supports, [$this->gateway, 'supports']),
			'icon'        => $this->gateway->icon,
		];
	}
}
